#ifndef _DPARSER_CHART_ITEM_
#define _DPARSER_CHART_ITEM_

#pragma once

#include <stdlib.h>
#include "common.h"
#include "FVec.h"
#include <list>
using namespace std;
using namespace egstra;

namespace dparser {

	class ChartItem
	{
	public:
		const int _i;
		const int _pos_id;
		const ChartItem * const _trace;
		const double _prob;
		const list<const fvec *> _fvs;

	public:
		ChartItem(const int i, const int pos_id, 
			const double prob=0.0, const list<const fvec *> &fvs=list<const fvec *>(),
			const ChartItem * const trace=0) : 
		_i(i), _pos_id(pos_id), _prob(prob), _fvs(fvs), _trace(trace)
		{}

		~ChartItem(void) {}

	private:
		// forbid
		ChartItem(const ChartItem &rhs) :		
		   _i(rhs._i), _pos_id(rhs._pos_id), _prob(rhs._prob), _fvs(rhs._fvs), _trace(rhs._trace)
		{
			   cerr << "not allow ChartItem::ChartItem(const ChartItem &rhs)" << endl;
			   exit(-1);
		}

		ChartItem &operator =(const ChartItem &rhs) {
			cerr << "not allow ChartItem::operator =(const ChartItem &rhs)" << endl;
			exit(-1);
			return *this;
		}
	};


}

#endif


